/*******************************************************
Filename		:  	DW_result_criteria_station.sql
Release 		:  	STORET c2.0
SIR			:  	1438, 1437, 1436, 1435
Description		:  	Creates a centralized form page that allows the user to select 
				Stations based on Organization.
Author			:  	Joseph Wilson/Christine Tsang
Date			: 	March 13, 2003
                        	03/17/2003 - Added date selection. -C Tsang
                        	03/18/2003 - Added characteristic selection. Replaced hard-coded
					 date logic with call to DW_DISPLAY_CALENDAR. -C Tsang
					04/07/2003 - Added station search type and Ext Ref Scheme to
					 station selection. -C Tsang
				04/14/2003 - Reset Date fields with JavaScript. -J Wilson
				04/24/2003 - Expanded Characteristic listbox width. Changed field descriptions. -CT
				04/28/2003 - Use adjust_width to line up column headers in Station listbox. -CT
				04/29/2003 - Generate char alias type list with a table query instead of hardcode. -CT   
                        	05/01/2003 - Pass '22' to footer routine to be used as a bookmark for the Help. - W Nash sir 1459  
                        	05/23/2003 SIR 1442 TIR#2 - Changed wording in date selection box. -CT
                        	06/13/2003 - Removed hardcoded schema (SIR 1483). -CT
				06/20/2003 SIR 1504 - Replaced code for station, date range and characteristics selections with 
                                     procedure calls. -CT
				07/22/2003 - Add hidden var RESULT_TYPE -JW
                        08/07/2003 SIR 1443 - Added Activity Medium selection. -CT
                        08/15/2003 - Removed 'BETA' from the page title. -CT
Comments		:  	Calls a pop-up window for Station selection.
**********************************************************/

SET DEF OFF;

CREATE or REPLACE PROCEDURE DW_ResultCriteria_STATION AS

--used to generate org list
CURSOR corg IS
SELECT pk_isn, organization_id, organization_name
FROM DI_ORG
ORDER BY organization_id;

program_path  	varchar2(1000) := null;
script_path   	varchar2(1000) := null;
image_path    	varchar2(1000) := null;
page_title    	varchar2(100)  :='Regular Results by Station';

BEGIN
DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path,
 'adjust_width_n(document.forms[1].D_ORG_LIST,"~","15~60","None","N");adjust_width_n(document.forms[1].station_list,"~","9~16~13~21~60","None","N");document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);self.focus();document.forms[1].D_ORG_LIST.focus();adjust_width_n(document.forms[1].D_MEDIUM_LIST,"~","30~","None","Y")');
htp.print('<form action="DW_RESULT_COUNT" method=POST>');

-- Org/Station selection
DW_station_select;

-- Date range selection 
DW_date_select(10);

-- Activity Medium selection
DW_medium_select(35);

-- Characteristics selection
DW_char_select(36);

htp.print('
<input type="hidden" name="RESULT_TYPE" value="REGULAR">
<br>
<center>
<input type="button" value="Continue" tabindex=43 onclick="javascript: submitCriteria3();" title="Submit Selection Criteria for processing">&nbsp&nbsp&nbsp
<input type="button" value="Clear Form" tabindex=44 onclick="javascript: deleteAllFromStationList(); deleteAllFromCharList(); document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);" title="Clear the form">
</center></form>
');
DW_bottom_of_page(22);

END;
/
SHOW ERRORS;